//
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  N o t e b o o k   H a r d w a r e   C o n t r o l   A C P I   D L L
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  for Hewlett-Packard Notebooks
//
//  This file is provided "as is" with no expressed or implied warranty.
//  The authors accepts no liability for any damage/loss of business that
//  this product may cause.
//
//   Author: Henry100, Mateusz Ludwin, vyky
//   This Files are written by Henry100 (the Information by Mateusz Ludwin!)
//
//  Last Update: 02 May 2007
//
public static class HEWLETT_PACKARD
{
    #region Notebook HP NC6000 : class NC6000
    //
    // class author: Henry100
    //
    public static class NC6000
    {

        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F5");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F5");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F5");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F6", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F5");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

    }

    #endregion
    //no fan-speed

    #region Notebook HP NX6125 : class NX6125
    //
    // class author: Henry100
    //
    public static class NX6125
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24E");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 70;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24E");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24E");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24E");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region Class for HP NX6125 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN Control (default value)
            // - - - - - - - - - - - - - - -
            //
            // Name (C23C, Package (0x05)
            // {
            //    0x64,             // 100°C    <- FAN maximum level
            //    0x50,             // 80°C     <- FAN high level
            //    0x41,             // 65°C     <- FAN middle level
            //    0x32,             // 50°C     <- FAN low level
            //    0x00
            // })            

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN low speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 50;                                // It must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                         // minimum input value
                    public const int nhc_maximum_value = 100;                        // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23C", "PKG[3]", low_level_on) == true)   // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;

                // Value
                public static int middle_level_on = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 65;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23C", "PKG[2]", middle_level_on) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;

                // Value
                public static int high_level_on = 80;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23C", "PKG[1]", high_level_on) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            //
            public static class FAN_MAXIMUM_SPEED
            {
                // Properties of the value class
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_maximum_speed = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23C", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C251._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C251._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C251._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C252._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C252._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C252._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C253._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C253._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C253._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C254._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C254._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C254._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion
    // works perfect

    #region Notebook HP NC6120 : class NC6120
    //
    // class author: Henry100
    //
    public static class NC6120
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C246");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 70;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C246");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C246");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C231", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C246");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region Class for HP NC6120 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN Control (default value)
            // - - - - - - - - - - - - - - -
            //
            // Name (C233, Package (0x05)
            // {
            //    0x64,             // 100°C    <- FAN maximum level
            //    0x4B,             // 75°C     <- FAN high level
            //    0x37,             // 55°C     <- FAN middle level
            //    0x28,             // 40°C     <- FAN low level
            //    0x00
            // })

            #region Value class for LOW_LEVEL_SPEED : class LOW_LEVEL_SPEED
            //
            public static class LOW_LEVEL_SPEED
            {
                // Properties of the value class
                public const string description = "LOW_LEVEL_SPEED";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_speed = 40;                          // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                   // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                         // minimum input value
                    public const int nhc_maximum_value = 100;                      // maximum input value
                    public const int nhc_default_value = 40;                      // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C233", "PKG[3]", low_level_speed) == true)     // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_SPEED : class MIDDLE_LEVEL_SPEED
            //
            public static class MIDDLE_LEVEL_SPEED
            {
                // Properties of the value class
                public const string description = "MIDDLE_LEVEL_SPEED";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_speed = 55;                          // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                   // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                         // minimum input value
                    public const int nhc_maximum_value = 100;                      // maximum input value
                    public const int nhc_default_value = 55;                      // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C233", "PKG[2]]", middle_level_speed) == true)     // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_SPEED : class HIGH_LEVEL_SPEED
            //
            public static class HIGH_LEVEL_SPEED
            {
                // Properties of the value class
                public const string description = "HIGH_LEVEL_SPEED";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_speed = 75;                          // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                   // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                         // minimum input value
                    public const int nhc_maximum_value = 100;                      // maximum input value
                    public const int nhc_default_value = 75;                      // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C233", "PKG[1]", high_level_speed) == true)     // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            //
            public static class FAN_MAXIMUM_SPEED
            {
                // Properties of the value class
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_maximum_speed = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C233", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C249._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C249._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C249._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C24A._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C24A._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C24A._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C24B._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C24B._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C24B._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C24C._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C24C._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C24C._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion
    // works perfect

    #region Notebook HP NX8220 : class NX8220
    //
    // class author: Henry100
    //
    public static class NX8220
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            //Scope (\_TZ)
            // {
            //   Name (C23A, Package (0x04)
            //  
            //  Package (0x02)
            //  {
            //      Package (0x06)
            //      {
            //          0x05AC,
            //          0x0C6E,     ->      FAN LOW LEVEL ON4
            //          0x0CD2,     ->      FAN MIDDLE LEVEL ON4
            //          0x0D18,     ->      FAN HIGH LEVEL ON4
            //          0x0DCC,     ->      FAN MAXIMUM LEVEL ON1
            //          0x0E30
            //     }, 
            //
            //      Package (0x06)
            //      {
            //          0x0CA0,     ->      FAN LOW LEVEL ON3
            //          0x0D04,     ->      FAN MIDDLE LEVEL ON3
            //          0x0D68,     ->      FAN HIGH LEVEL ON3
            //          0x0DFE,     ->      FAN MAXIMUM LEVEL ON1 
            //          0x0E94, 
            //          0x0FA3
            //      }
            //  }, 
            //
            //  Package (0x02)
            //  {
            //      Package (0x06)
            //      {
            //          0x05AC, 
            //          0x0C6E,     ->      FAN LOW LEVEL ON2
            //          0x0CD2,     ->      FAN MIDDLE LEVEL ON2
            //          0x0D18,     ->      FAN HIGH LEVEL ON2 
            //          0x0DCC,     ->      FAN MAXIMUM LEVEL ON1 
            //          0x0E30
            //      }, 
            //
            //      Package (0x06)
            //      {
            //          0x7E42,     ->      FAN LOW LEVEL ON1
            //          0x0D04,     ->      FAN MIDDLE LEVEL ON1
            //          0x0D68,     ->      FAN HIGH LEVEL ON1
            //          0x0DFE,     ->      FAN MAXIMUM LEVEL ON1
            //          0x0E94, 
            //          0x0FA3

            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24E");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 70;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24E");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24E");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24E");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region Class for HP NX8220 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN Control (default value)
            // - - - - - - - - - - - - - - -
            //
            // Name (C23B, Package (0x05)
            // {
            //    0x64,             // 100°C    <- FAN maximum level
            //    0x41,             // 65°C     <- FAN high level
            //    0x37,             // 55°C     <- FAN middle level
            //    0x28,             // 40°C     <- FAN low level
            //    0x00
            // })


            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 40;                                // It must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                         // minimum input value
                    public const int nhc_maximum_value = 100;                        // maximum input value
                    public const int nhc_default_value = 40;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23B", "PKG[3]", fan_low_speed) == true)   // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_middle_speed = 55;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 55;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23B", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_high_speed = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 65;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23B", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            //
            public static class FAN_MAXIMUM_SPEED
            {
                // Properties of the value class
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_maximum_speed = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23B", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C251._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C251._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C251._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C252._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C252._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C252._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C253._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C253._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C253._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C254._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C254._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C254._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }  //
    #endregion
    //works perfect BIOS: F.14

    #region Notebook HP NX6325 : class NX6325
    //
    // class author: Henry100
    //
    public static class NX6325
    {

        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C35D");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C35D");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C35D");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C348", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C35D");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

    }

    #endregion
    // no fan-speed F.06

    #region Notebook HP NC8430 : class NC8430
    //
    // class author: vyky
    //
    public static class NC8430
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-LEVEL Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C305, Package (0x04)
            //      {
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //            {
            //                  0x05AC, 
            //                  0x00,               //45°C      <- TZ0 Active cooling temperature 3 OFF (Fan low speed OFF)
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x00,               //65°C      <- TZ0 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x00                //75°C      <- TZ0 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 3 ON (Fan low speed ON)
            //                  0x00,               //60°C      <- TZ0 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x00,               //72°C      <- TZ0 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x00,               //83°C      <- TZ0 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x14AC              //256°C     <- Critical temperature (DTS)
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x03)
            //              {
            //                  0x05AC, 
            //                  0x0DFE, 
            //                  0x0E08
            //              }, 
            //              Package (0x03)
            //              {
            //                  0x0EA8, 
            //                  0x0EC6, 
            //                  0x0FA3
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //              {
            //                  0x05AC, 
            //                  0x0D36,             //65°C      <- TZ2 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x0DFE,             //85°C      <- TZ2 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x0E30,             //90°C      <- TZ2 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //                  0x0E6C              //96°C      <- Critical temperature OFF
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x0D9A,             //75°C      <- TZ2 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x0E62,             //95°C      <- TZ2 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x0EC6,             //105°C     <- TZ2 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x0EF8,             //110°C     <- Critical temperature ON
            //                  0x0FA3
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x02)
            //              {
            //                  0x05AC, 
            //                  0x0CA0
            //              }, 
            //              Package (0x02)
            //              {
            //                  0x0D04, 
            //                  0x0FA3
            //              }
            //          }
            //      })

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                int graphics_range3 = 0;
                int graphics_range2 = 0;
                int graphics_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                ACPI.PACKAGE.Read("_TZ.C305", "PKG[2].PKG[1].PKG[2]", ref graphics_range3);     // read actual graphic range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[2].PKG[1].PKG[1]", ref graphics_range2);     // read actual graphic range (Fan high speed) 
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[2].PKG[1].PKG[0]", ref graphics_range1);     // read actual graphic range (Fan medium speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C323._OFF");
                ACPI.METHOD.Call("_TZ.C324._OFF");
                ACPI.METHOD.Call("_TZ.C325._OFF");
                ACPI.METHOD.Call("_TZ.C326._OFF");
                ACPI.METHOD.Call("_TZ.C327._OFF");
                ACPI.METHOD.Call("_TZ.C328._OFF");
                ACPI.METHOD.Call("_TZ.C329._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C323._ON");
                    result = ACPI.METHOD.Call("_TZ.C324._ON");
                    result = ACPI.METHOD.Call("_TZ.C325._ON");
                    result = ACPI.METHOD.Call("_TZ.C326._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C323._OFF");
                        result = ACPI.METHOD.Call("_TZ.C324._ON");
                        result = ACPI.METHOD.Call("_TZ.C325._ON");
                        result = ACPI.METHOD.Call("_TZ.C326._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C323._OFF");
                            result = ACPI.METHOD.Call("_TZ.C324._OFF");
                            result = ACPI.METHOD.Call("_TZ.C325._ON");
                            result = ACPI.METHOD.Call("_TZ.C326._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C323._OFF");
                                result = ACPI.METHOD.Call("_TZ.C324._OFF");
                                result = ACPI.METHOD.Call("_TZ.C325._OFF");
                                result = ACPI.METHOD.Call("_TZ.C326._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C323._OFF");
                                result = ACPI.METHOD.Call("_TZ.C324._OFF");
                                result = ACPI.METHOD.Call("_TZ.C325._OFF");
                                result = ACPI.METHOD.Call("_TZ.C326._OFF");
                            }
                        }
                    }
                }

                if (temp2 > graphics_range3)
                {
                    result = ACPI.METHOD.Call("_TZ.C327._ON");
                    result = ACPI.METHOD.Call("_TZ.C328._ON");
                    result = ACPI.METHOD.Call("_TZ.C329._ON");
                }
                else
                {
                    if (temp2 > graphics_range2)
                    {
                        result = ACPI.METHOD.Call("_TZ.C327._OFF");
                        result = ACPI.METHOD.Call("_TZ.C328._ON");
                        result = ACPI.METHOD.Call("_TZ.C329._ON");
                    }
                    else
                    {
                        if (temp2 > graphics_range1)
                        {
                            result = ACPI.METHOD.Call("_TZ.C327._OFF");
                            result = ACPI.METHOD.Call("_TZ.C328._OFF");
                            result = ACPI.METHOD.Call("_TZ.C329._ON");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C327._OFF");
                            result = ACPI.METHOD.Call("_TZ.C328._OFF");
                            result = ACPI.METHOD.Call("_TZ.C329._OFF");
                        }
                    }
                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP NC8430 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-SPEED Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C306, Package (0x05)
            //      {
            //          0x64,            // 100%     <- Fan maximum speed
            //          0x50,            // 80%      <- Fan high speed
            //          0x46,            // 70%      <- Fan middle speed
            //          0x37,            // 55%      <- Fan low speed 
            //          0x00
            //      })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C306", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C306", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C306", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C306", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                int graphics_range3 = 0;
                int graphics_range2 = 0;
                int graphics_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                ACPI.PACKAGE.Read("_TZ.C305", "PKG[2].PKG[1].PKG[2]", ref graphics_range3);     // read actual graphic range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[2].PKG[1].PKG[1]", ref graphics_range2);     // read actual graphic range (Fan high speed) 
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[2].PKG[1].PKG[0]", ref graphics_range1);     // read actual graphic range (Fan medium speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C323._OFF");
                ACPI.METHOD.Call("_TZ.C324._OFF");
                ACPI.METHOD.Call("_TZ.C325._OFF");
                ACPI.METHOD.Call("_TZ.C326._OFF");
                ACPI.METHOD.Call("_TZ.C327._OFF");
                ACPI.METHOD.Call("_TZ.C328._OFF");
                ACPI.METHOD.Call("_TZ.C329._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C323._ON");
                    result = ACPI.METHOD.Call("_TZ.C324._ON");
                    result = ACPI.METHOD.Call("_TZ.C325._ON");
                    result = ACPI.METHOD.Call("_TZ.C326._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C323._OFF");
                        result = ACPI.METHOD.Call("_TZ.C324._ON");
                        result = ACPI.METHOD.Call("_TZ.C325._ON");
                        result = ACPI.METHOD.Call("_TZ.C326._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C323._OFF");
                            result = ACPI.METHOD.Call("_TZ.C324._OFF");
                            result = ACPI.METHOD.Call("_TZ.C325._ON");
                            result = ACPI.METHOD.Call("_TZ.C326._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C323._OFF");
                                result = ACPI.METHOD.Call("_TZ.C324._OFF");
                                result = ACPI.METHOD.Call("_TZ.C325._OFF");
                                result = ACPI.METHOD.Call("_TZ.C326._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C323._OFF");
                                result = ACPI.METHOD.Call("_TZ.C324._OFF");
                                result = ACPI.METHOD.Call("_TZ.C325._OFF");
                                result = ACPI.METHOD.Call("_TZ.C326._OFF");
                            }
                        }
                    }
                }

                if (temp2 > graphics_range3)
                {
                    result = ACPI.METHOD.Call("_TZ.C327._ON");
                    result = ACPI.METHOD.Call("_TZ.C328._ON");
                    result = ACPI.METHOD.Call("_TZ.C329._ON");
                }
                else
                {
                    if (temp2 > graphics_range2)
                    {
                        result = ACPI.METHOD.Call("_TZ.C327._OFF");
                        result = ACPI.METHOD.Call("_TZ.C328._ON");
                        result = ACPI.METHOD.Call("_TZ.C329._ON");
                    }
                    else
                    {
                        if (temp2 > graphics_range1)
                        {
                            result = ACPI.METHOD.Call("_TZ.C327._OFF");
                            result = ACPI.METHOD.Call("_TZ.C328._OFF");
                            result = ACPI.METHOD.Call("_TZ.C329._ON");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C327._OFF");
                            result = ACPI.METHOD.Call("_TZ.C328._OFF");
                            result = ACPI.METHOD.Call("_TZ.C329._OFF");
                        }
                    }
                }
                return result;
            }
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return refresh_thermal_zone();                                 // refresh the ThermalZone (Temperature and FAN Speed)
            }
        }
        #endregion
    }
    #endregion
    // works perfect F.0F

    #region Notebook HP NX6310 : class NX6310

    public static class NX6310
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-LEVEL Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C305, Package (0x04)
            //      {
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //            {
            //                  0x05AC, 
            //                  0x00,               //45°C      <- TZ0 Active cooling temperature 3 OFF (Fan low speed OFF)
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x00,               //65°C      <- TZ0 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x00                //75°C      <- TZ0 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 3 ON (Fan low speed ON)
            //                  0x00,               //60°C      <- TZ0 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x00,               //72°C      <- TZ0 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x00,               //83°C      <- TZ0 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x14AC              //256°C     <- Critical temperature (DTS)


            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C305", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C305", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                // This switch off the Fan 
                ACPI.METHOD.Call("_TZ.C321._OFF");
                ACPI.METHOD.Call("_TZ.C322._OFF");
                ACPI.METHOD.Call("_TZ.C323._OFF");
                ACPI.METHOD.Call("_TZ.C324._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C321._ON");
                    result = ACPI.METHOD.Call("_TZ.C322._ON");
                    result = ACPI.METHOD.Call("_TZ.C323._ON");
                    result = ACPI.METHOD.Call("_TZ.C324._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C321._OFF");
                        result = ACPI.METHOD.Call("_TZ.C322._ON");
                        result = ACPI.METHOD.Call("_TZ.C323._ON");
                        result = ACPI.METHOD.Call("_TZ.C324._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C321._OFF");
                            result = ACPI.METHOD.Call("_TZ.C322._OFF");
                            result = ACPI.METHOD.Call("_TZ.C323._ON");
                            result = ACPI.METHOD.Call("_TZ.C324._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C321._OFF");
                                result = ACPI.METHOD.Call("_TZ.C322._OFF");
                                result = ACPI.METHOD.Call("_TZ.C323._OFF");
                                result = ACPI.METHOD.Call("_TZ.C324._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C321._OFF");
                                result = ACPI.METHOD.Call("_TZ.C322._OFF");
                                result = ACPI.METHOD.Call("_TZ.C323._OFF");
                                result = ACPI.METHOD.Call("_TZ.C324._OFF");
                            }
                        }
                    }


                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP NCX6310 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C307", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C307", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C307", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C307", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C321._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C321._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C321._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C322._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C322._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C322._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C323._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C323._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C323._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C324._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C324._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C324._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }

        #endregion
    }

    #endregion
    // works perfect

    #region Notebook HP NW8240 : class NW8240
    //
    // class author: Henry100
    //
    public static class NW8240
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C252");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C252");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C252");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C253", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C252");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

    }

    #endregion
    // no fan-speed

    #region Notebook HP NC8000 : class NC8000
    //
    // class author: Henry100
    //
    public static class NC8000
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F8");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F8");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F8");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F9", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F8");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

    }
    #endregion
    // no fan-speed

    #region Notebook HP NX6110 : class NX6110
    //
    // class author: Mateusz Ludwin
    //
    public static class NX6110
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Third package
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Fourth package
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Notify the fan
                        return ACPI.METHOD.Call("_TZ.C241");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Third package
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Fourth package
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Notify the fan
                        return ACPI.METHOD.Call("_TZ.C241");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Third package
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Fourth package
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Notify the fan
                        return ACPI.METHOD.Call("_TZ.C241");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22D", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Third package
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Fourth package
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C22E", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Notify the fan
                        return ACPI.METHOD.Call("_TZ.C241");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region Class for HP NX6110 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN Control (default value)
            // - - - - - - - - - - - - - - -
            //
            // Name (C22F, Package (0x05)
            // {
            //    0x64,             // 100°C    <- FAN maximum level
            //    0x4B,             // 65°C     <- FAN high level
            //    0x37,             // 55°C     <- FAN middle level
            //    0x28,             // 40°C     <- FAN low level
            //    0x00
            // })


            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 40;                                // It must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                         // minimum input value
                    public const int nhc_maximum_value = 100;                        // maximum input value
                    public const int nhc_default_value = 40;                        // default value
                    public static bool nhc_on_write()                              // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C22F", "PKG[3]", fan_low_speed) == true)   // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_middle_speed = 55;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 55;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C22F", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_high_speed = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 65;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C22F", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            //
            public static class FAN_MAXIMUM_SPEED
            {
                // Properties of the value class
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_maximum_speed = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C22F", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C244._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C244._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C244._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C245._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C245._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C245._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C246._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C246._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C246._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C247._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C247._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C247._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }

    #endregion
    // works perfect

    #region Notebook HP NX5000 : class NX5000
    //
    // class author: Henry100
    //
    public static class NX5000
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1E8");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1E8");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1E8");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1E9", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1E8");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

    }
    #endregion
    // no fan-speed

    #region Notebook HP NX7400 : class NX7400

    public static class NX7400
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-LEVEL Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C2F8, Package (0x04)
            //      {
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //            {
            //                  0x05AC, 
            //                  0x00,               //45°C      <- TZ0 Active cooling temperature 3 OFF (Fan low speed OFF)
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x00,               //65°C      <- TZ0 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x00                //75°C      <- TZ0 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 3 ON (Fan low speed ON)
            //                  0x00,               //60°C      <- TZ0 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x00,               //72°C      <- TZ0 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x00,               //83°C      <- TZ0 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x14AC              //256°C     <- Critical temperature (DTS)
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x03)
            //              {
            //                  0x05AC, 
            //                  0x0DFE, 
            //                  0x0E08
            //              }, 
            //              Package (0x03)
            //              {
            //                  0x0EA8, 
            //                  0x0EC6, 
            //                  0x0FA3
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //              {
            //                  0x05AC, 
            //                  0x0D36,             //65°C      <- TZ2 Active cooling temperature 2 OFF
            //                  0x0DFE,             //85°C      <- TZ2 Active cooling temperature 1 OFF
            //                  0x0E30,             //90°C      <- TZ2 Active cooling temperature 0 OFF
            //                  0x0E6C              //96°C      <- Critical temperature OFF
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x0D9A,             //75°C      <- TZ2 Active cooling temperature 2 ON
            //                  0x0E62,             //95°C      <- TZ2 Active cooling temperature 1 ON
            //                  0x0EC6,             //105°C     <- TZ2 Active cooling temperature 0 ON
            //                  0x0EF8,             //110°C     <- Critical temperature ON
            //                  0x0FA3
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x02)
            //              {
            //                  0x05AC, 
            //                  0x0CA0
            //              }, 
            //              Package (0x02)
            //              {
            //                  0x0D04, 
            //                  0x0FA3
            //              }
            //          }
            //      })

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2F8", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2F8", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2F8", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2F8", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2F8", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2F8", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2F8", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2F8", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                int graphics_range3 = 0;
                int graphics_range2 = 0;
                int graphics_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C2F8", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C2F8", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C2F8", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C2F8", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                ACPI.PACKAGE.Read("_TZ.C2F8", "PKG[2].PKG[1].PKG[2]", ref graphics_range3);     // read actual graphic range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C2F8", "PKG[2].PKG[1].PKG[1]", ref graphics_range2);     // read actual graphic range (Fan high speed) 
                ACPI.PACKAGE.Read("_TZ.C2F8", "PKG[2].PKG[1].PKG[0]", ref graphics_range1);     // read actual graphic range (Fan medium speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C314._OFF");
                ACPI.METHOD.Call("_TZ.C315._OFF");
                ACPI.METHOD.Call("_TZ.C316._OFF");
                ACPI.METHOD.Call("_TZ.C317._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C314._ON");
                    result = ACPI.METHOD.Call("_TZ.C315._ON");
                    result = ACPI.METHOD.Call("_TZ.C316._ON");
                    result = ACPI.METHOD.Call("_TZ.C317._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C314._OFF");
                        result = ACPI.METHOD.Call("_TZ.C315._ON");
                        result = ACPI.METHOD.Call("_TZ.C316._ON");
                        result = ACPI.METHOD.Call("_TZ.C317._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C314._OFF");
                            result = ACPI.METHOD.Call("_TZ.C315._OFF");
                            result = ACPI.METHOD.Call("_TZ.C316._ON");
                            result = ACPI.METHOD.Call("_TZ.C317._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C314._OFF");
                                result = ACPI.METHOD.Call("_TZ.C315._OFF");
                                result = ACPI.METHOD.Call("_TZ.C316._OFF");
                                result = ACPI.METHOD.Call("_TZ.C317._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C314._OFF");
                                result = ACPI.METHOD.Call("_TZ.C315._OFF");
                                result = ACPI.METHOD.Call("_TZ.C316._OFF");
                                result = ACPI.METHOD.Call("_TZ.C317._OFF");
                            }
                        }
                    }


                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP NX7400 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-SPEED Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C2FA, Package (0x05)
            //      {
            //          0x64,            // 100%     <- Fan maximum speed
            //          0x41,            // 80%      <- Fan high speed
            //          0x37,            // 70%      <- Fan middle speed
            //          0x23,            // 55%      <- Fan low speed 
            //          0x00
            //      })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2FA", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2FA", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2FA", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2FA", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C314._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C314._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C314._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C315._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C315._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C315._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C316._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C316._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C316._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C317._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C317._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C317._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }

        #endregion
    }

    #endregion
    // works perfect F.0A

    #region Notebook HP TC4400 : class TC4400

    public static class TC4400
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-LEVEL Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C311, Package (0x04)
            //      {
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //            {
            //                  0x05AC, 
            //                  0x00,               //45°C      <- TZ0 Active cooling temperature 3 OFF (Fan low speed OFF)
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x00,               //65°C      <- TZ0 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x00                //75°C      <- TZ0 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 3 ON (Fan low speed ON)
            //                  0x00,               //60°C      <- TZ0 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x00,               //72°C      <- TZ0 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x00,               //83°C      <- TZ0 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x14AC              //256°C     <- Critical temperature (DTS)


            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                int graphics_range3 = 0;
                int graphics_range2 = 0;
                int graphics_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C311", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                ACPI.PACKAGE.Read("_TZ.C311", "PKG[2].PKG[1].PKG[2]", ref graphics_range3);     // read actual graphic range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[2].PKG[1].PKG[1]", ref graphics_range2);     // read actual graphic range (Fan high speed) 
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[2].PKG[1].PKG[0]", ref graphics_range1);     // read actual graphic range (Fan medium speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C329._OFF");
                ACPI.METHOD.Call("_TZ.C32A._OFF");
                ACPI.METHOD.Call("_TZ.C32B._OFF");
                ACPI.METHOD.Call("_TZ.C32C._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C329._ON");
                    result = ACPI.METHOD.Call("_TZ.C32A._ON");
                    result = ACPI.METHOD.Call("_TZ.C32B._ON");
                    result = ACPI.METHOD.Call("_TZ.C32C._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C329._OFF");
                        result = ACPI.METHOD.Call("_TZ.C32A._ON");
                        result = ACPI.METHOD.Call("_TZ.C32B._ON");
                        result = ACPI.METHOD.Call("_TZ.C32C._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C329._OFF");
                            result = ACPI.METHOD.Call("_TZ.C32A._OFF");
                            result = ACPI.METHOD.Call("_TZ.C32B._ON");
                            result = ACPI.METHOD.Call("_TZ.C32C._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C329._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32A._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32B._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32C._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C329._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32A._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32B._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32C._OFF");
                            }
                        }
                    }


                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP TC4400 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C313", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C313", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C313", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C313", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C329._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C329._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C329._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C32A._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C32A._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C32A._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C32B._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C32B._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C32B._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C32C._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C32C._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C32C._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }

        #endregion
    }

    #endregion
    // works perfect F.07

    #region Notebook HP TC4200 : class TC4200

    public static class TC4200
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-LEVEL Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C248, Package (0x04)
            //      {
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //            {
            //                  0x05AC, 
            //                  0x00,               //45°C      <- TZ0 Active cooling temperature 3 OFF (Fan low speed OFF)
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x00,               //65°C      <- TZ0 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x00                //75°C      <- TZ0 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 3 ON (Fan low speed ON)
            //                  0x00,               //60°C      <- TZ0 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x00,               //72°C      <- TZ0 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x00,               //83°C      <- TZ0 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x14AC              //256°C     <- Critical temperature (DTS)
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x03)
            //              {
            //                  0x05AC, 
            //                  0x0DFE, 
            //                  0x0E08
            //              }, 
            //              Package (0x03)
            //              {
            //                  0x0EA8, 
            //                  0x0EC6, 
            //                  0x0FA3
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //              {
            //                  0x05AC, 
            //                  0x0D36,             //65°C      <- TZ2 Active cooling temperature 2 OFF
            //                  0x0DFE,             //85°C      <- TZ2 Active cooling temperature 1 OFF
            //                  0x0E30,             //90°C      <- TZ2 Active cooling temperature 0 OFF
            //                  0x0E6C              //96°C      <- Critical temperature OFF
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x0D9A,             //75°C      <- TZ2 Active cooling temperature 2 ON
            //                  0x0E62,             //95°C      <- TZ2 Active cooling temperature 1 ON
            //                  0x0EC6,             //105°C     <- TZ2 Active cooling temperature 0 ON
            //                  0x0EF8,             //110°C     <- Critical temperature ON
            //                  0x0FA3
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x02)
            //              {
            //                  0x05AC, 
            //                  0x0CA0
            //              }, 
            //              Package (0x02)
            //              {
            //                  0x0D04, 
            //                  0x0FA3
            //              }
            //          }
            //      })

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C248", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C248", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C248", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C248", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C248", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C248", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C248", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C248", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C248", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C248", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C248", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C248", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C262._OFF");
                ACPI.METHOD.Call("_TZ.C263._OFF");
                ACPI.METHOD.Call("_TZ.C264._OFF");
                ACPI.METHOD.Call("_TZ.C265._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C262._ON");
                    result = ACPI.METHOD.Call("_TZ.C263._ON");
                    result = ACPI.METHOD.Call("_TZ.C264._ON");
                    result = ACPI.METHOD.Call("_TZ.C265._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C262._OFF");
                        result = ACPI.METHOD.Call("_TZ.C263._ON");
                        result = ACPI.METHOD.Call("_TZ.C264._ON");
                        result = ACPI.METHOD.Call("_TZ.C265._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C262._OFF");
                            result = ACPI.METHOD.Call("_TZ.C263._OFF");
                            result = ACPI.METHOD.Call("_TZ.C264._ON");
                            result = ACPI.METHOD.Call("_TZ.C265._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C262._OFF");
                                result = ACPI.METHOD.Call("_TZ.C263._OFF");
                                result = ACPI.METHOD.Call("_TZ.C264._OFF");
                                result = ACPI.METHOD.Call("_TZ.C265._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C262._OFF");
                                result = ACPI.METHOD.Call("_TZ.C263._OFF");
                                result = ACPI.METHOD.Call("_TZ.C264._OFF");
                                result = ACPI.METHOD.Call("_TZ.C265._OFF");
                            }
                        }
                    }


                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP TC4200 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-SPEED Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C2FA, Package (0x05)
            //      {
            //          0x64,            // 100%     <- Fan maximum speed
            //          0x41,            // 80%      <- Fan high speed
            //          0x37,            // 70%      <- Fan middle speed
            //          0x23,            // 55%      <- Fan low speed 
            //          0x00
            //      })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C249", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C249", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C249", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C249", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C262._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C262._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C262._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C263._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C263._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C263._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C264._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C264._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C264._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C265._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C265._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C265._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }

        #endregion
    }

    #endregion
    // test F.0D

    #region Notebook HP NC6320 : class NC6320

    public static class NC6320
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-LEVEL Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C2F5, Package (0x04)
            //      {
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //            {
            //                  0x05AC, 
            //                  0x00,               //45°C      <- TZ0 Active cooling temperature 3 OFF (Fan low speed OFF)
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x00,               //65°C      <- TZ0 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x00                //75°C      <- TZ0 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 3 ON (Fan low speed ON)
            //                  0x00,               //60°C      <- TZ0 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x00,               //72°C      <- TZ0 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x00,               //83°C      <- TZ0 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x14AC              //256°C     <- Critical temperature (DTS)


            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2F5", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2F5", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2F5", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2F5", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2F5", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2F5", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2F5", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2F5", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                int graphics_range3 = 0;
                int graphics_range2 = 0;
                int graphics_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C2F5", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C2F5", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C2F5", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C2F5", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                ACPI.PACKAGE.Read("_TZ.C2F5", "PKG[2].PKG[1].PKG[2]", ref graphics_range3);     // read actual graphic range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C2F5", "PKG[2].PKG[1].PKG[1]", ref graphics_range2);     // read actual graphic range (Fan high speed) 
                ACPI.PACKAGE.Read("_TZ.C2F5", "PKG[2].PKG[1].PKG[0]", ref graphics_range1);     // read actual graphic range (Fan medium speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C311._OFF");
                ACPI.METHOD.Call("_TZ.C312._OFF");
                ACPI.METHOD.Call("_TZ.C313._OFF");
                ACPI.METHOD.Call("_TZ.C314._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C311._ON");
                    result = ACPI.METHOD.Call("_TZ.C312._ON");
                    result = ACPI.METHOD.Call("_TZ.C313._ON");
                    result = ACPI.METHOD.Call("_TZ.C314._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C311._OFF");
                        result = ACPI.METHOD.Call("_TZ.C312._ON");
                        result = ACPI.METHOD.Call("_TZ.C313._ON");
                        result = ACPI.METHOD.Call("_TZ.C314._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C311._OFF");
                            result = ACPI.METHOD.Call("_TZ.C312._OFF");
                            result = ACPI.METHOD.Call("_TZ.C313._ON");
                            result = ACPI.METHOD.Call("_TZ.C314._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C311._OFF");
                                result = ACPI.METHOD.Call("_TZ.C312._OFF");
                                result = ACPI.METHOD.Call("_TZ.C313._OFF");
                                result = ACPI.METHOD.Call("_TZ.C314._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C311._OFF");
                                result = ACPI.METHOD.Call("_TZ.C312._OFF");
                                result = ACPI.METHOD.Call("_TZ.C313._OFF");
                                result = ACPI.METHOD.Call("_TZ.C314._OFF");
                            }
                        }
                    }


                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP NC6320 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2F7", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2F7", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2F7", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2F7", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C311._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C311._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C311._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C312._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C312._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C312._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C313._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C313._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C313._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C314._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C314._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C314._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }

        #endregion
    }

    #endregion
    // works perfect

    #region Notebook HP NC6400 : class NC6400

    public static class NC6400
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-LEVEL Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C311, Package (0x04)
            //      {
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //            {
            //                  0x05AC, 
            //                  0x00,               //45°C      <- TZ0 Active cooling temperature 3 OFF (Fan low speed OFF)
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x00,               //65°C      <- TZ0 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x00                //75°C      <- TZ0 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 3 ON (Fan low speed ON)
            //                  0x00,               //60°C      <- TZ0 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x00,               //72°C      <- TZ0 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x00,               //83°C      <- TZ0 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x14AC              //256°C     <- Critical temperature (DTS)


            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C311", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                int graphics_range3 = 0;
                int graphics_range2 = 0;
                int graphics_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C311", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                ACPI.PACKAGE.Read("_TZ.C311", "PKG[2].PKG[1].PKG[2]", ref graphics_range3);     // read actual graphic range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[2].PKG[1].PKG[1]", ref graphics_range2);     // read actual graphic range (Fan high speed) 
                ACPI.PACKAGE.Read("_TZ.C311", "PKG[2].PKG[1].PKG[0]", ref graphics_range1);     // read actual graphic range (Fan medium speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C32D._OFF");
                ACPI.METHOD.Call("_TZ.C32E._OFF");
                ACPI.METHOD.Call("_TZ.C32F._OFF");
                ACPI.METHOD.Call("_TZ.C330._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C32D._ON");
                    result = ACPI.METHOD.Call("_TZ.C32E._ON");
                    result = ACPI.METHOD.Call("_TZ.C32F._ON");
                    result = ACPI.METHOD.Call("_TZ.C330._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C32D._OFF");
                        result = ACPI.METHOD.Call("_TZ.C32E._ON");
                        result = ACPI.METHOD.Call("_TZ.C32F._ON");
                        result = ACPI.METHOD.Call("_TZ.C330._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C32D._OFF");
                            result = ACPI.METHOD.Call("_TZ.C32E._OFF");
                            result = ACPI.METHOD.Call("_TZ.C32F._ON");
                            result = ACPI.METHOD.Call("_TZ.C330._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C32D._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32E._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32F._OFF");
                                result = ACPI.METHOD.Call("_TZ.C330._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C32D._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32E._OFF");
                                result = ACPI.METHOD.Call("_TZ.C32F._OFF");
                                result = ACPI.METHOD.Call("_TZ.C330._OFF");
                            }
                        }
                    }


                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP NC6400 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C313", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C313", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C313", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C313", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C32D._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C32D._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C32D._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C32E._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C32E._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C32E._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C32F._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C32F._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C32F._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C330._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C330._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C330._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }

        #endregion
    }

    #endregion
    // works perfect F.08

    #region Notebook HP NX9420 : class NX9420

    public static class NX9420
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN-LEVEL Control (default values)
            // - - - - - - - - - - - - - - -
            //      Name (C313, Package (0x04)
            //      {
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //            {
            //                  0x05AC, 
            //                  0x00,               //45°C      <- TZ0 Active cooling temperature 3 OFF (Fan low speed OFF)
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 2 OFF (Fan middle speed OFF)
            //                  0x00,               //65°C      <- TZ0 Active cooling temperature 1 OFF (Fan high speed OFF)
            //                  0x00                //75°C      <- TZ0 Active cooling temperature 0 OFF (Fan maximum speed OFF)
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x00,               //50°C      <- TZ0 Active cooling temperature 3 ON (Fan low speed ON)
            //                  0x00,               //60°C      <- TZ0 Active cooling temperature 2 ON (Fan middle speed ON)
            //                  0x00,               //72°C      <- TZ0 Active cooling temperature 1 ON (Fan high speed ON)
            //                  0x00,               //83°C      <- TZ0 Active cooling temperature 0 ON (Fan maximum speed ON)
            //                  0x14AC              //256°C     <- Critical temperature (DTS)
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x03)
            //              {
            //                  0x05AC, 
            //                  0x0DFE, 
            //                  0x0E08
            //              }, 
            //              Package (0x03)
            //              {
            //                  0x0EA8, 
            //                  0x0EC6, 
            //                  0x0FA3
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x05)
            //              {
            //                  0x05AC, 
            //                  0x0D36,             //65°C      <- TZ2 Active cooling temperature 2 OFF
            //                  0x0DFE,             //85°C      <- TZ2 Active cooling temperature 1 OFF
            //                  0x0E30,             //90°C      <- TZ2 Active cooling temperature 0 OFF
            //                  0x0E6C              //96°C      <- Critical temperature OFF
            //              }, 
            //              Package (0x05)
            //              {
            //                  0x0D9A,             //75°C      <- TZ2 Active cooling temperature 2 ON
            //                  0x0E62,             //95°C      <- TZ2 Active cooling temperature 1 ON
            //                  0x0EC6,             //105°C     <- TZ2 Active cooling temperature 0 ON
            //                  0x0EF8,             //110°C     <- Critical temperature ON
            //                  0x0FA3
            //              }
            //          }, 
            //          Package (0x02)
            //          {
            //              Package (0x02)
            //              {
            //                  0x05AC, 
            //                  0x0CA0
            //              }, 
            //              Package (0x02)
            //              {
            //                  0x0D04, 
            //                  0x0FA3
            //              }
            //          }
            //      })

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C313", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C313", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C313", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C313", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C313", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C313", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C313", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C313", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C313", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C313", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C313", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C313", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C334._OFF");
                ACPI.METHOD.Call("_TZ.C335._OFF");
                ACPI.METHOD.Call("_TZ.C336._OFF");
                ACPI.METHOD.Call("_TZ.C337._OFF");


                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C334._ON");
                    result = ACPI.METHOD.Call("_TZ.C335._ON");
                    result = ACPI.METHOD.Call("_TZ.C336._ON");
                    result = ACPI.METHOD.Call("_TZ.C337._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C334._OFF");
                        result = ACPI.METHOD.Call("_TZ.C335._ON");
                        result = ACPI.METHOD.Call("_TZ.C336._ON");
                        result = ACPI.METHOD.Call("_TZ.C337._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C334._OFF");
                            result = ACPI.METHOD.Call("_TZ.C335._OFF");
                            result = ACPI.METHOD.Call("_TZ.C336._ON");
                            result = ACPI.METHOD.Call("_TZ.C337._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C334._OFF");
                                result = ACPI.METHOD.Call("_TZ.C335._OFF");
                                result = ACPI.METHOD.Call("_TZ.C336._OFF");
                                result = ACPI.METHOD.Call("_TZ.C337._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C334._OFF");
                                result = ACPI.METHOD.Call("_TZ.C335._OFF");
                                result = ACPI.METHOD.Call("_TZ.C336._OFF");
                                result = ACPI.METHOD.Call("_TZ.C337._OFF");
                            }
                        }
                    }
                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP NX9420 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C316", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C316", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C316", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C316", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C334._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C334._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C334._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C335._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C335._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C335._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C336._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C336._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C336._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C337._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C337._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C337._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }

        #endregion
    }

    #endregion
    // works perfect F.19

    #region Notebook HP NC6220 : class NC6220
    //
    // class author: Henry100
    //
    public static class NC6220
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            //Scope (\_TZ)
            // {
            //   Name (C239, Package (0x04)
            //  
            //  Package (0x02)
            //  {
            //      Package (0x06)
            //      {
            //          0x05AC,
            //          0x0C6E,     ->      FAN LOW LEVEL ON4
            //          0x0CD2,     ->      FAN MIDDLE LEVEL ON4
            //          0x0D18,     ->      FAN HIGH LEVEL ON4
            //          0x0DCC,     ->      FAN MAXIMUM LEVEL ON1
            //          0x0E30
            //     }, 
            //
            //      Package (0x06)
            //      {
            //          0x0CA0,     ->      FAN LOW LEVEL ON3
            //          0x0D04,     ->      FAN MIDDLE LEVEL ON3
            //          0x0D68,     ->      FAN HIGH LEVEL ON3
            //          0x0DFE,     ->      FAN MAXIMUM LEVEL ON1 
            //          0x0E94, 
            //          0x0FA3
            //      }
            //  }, 
            //
            //  Package (0x02)
            //  {
            //      Package (0x06)
            //      {
            //          0x05AC, 
            //          0x0C6E,     ->      FAN LOW LEVEL ON2
            //          0x0CD2,     ->      FAN MIDDLE LEVEL ON2
            //          0x0D18,     ->      FAN HIGH LEVEL ON2 
            //          0x0DCC,     ->      FAN MAXIMUM LEVEL ON1 
            //          0x0E30
            //      }, 
            //
            //      Package (0x06)
            //      {
            //          0x7E42,     ->      FAN LOW LEVEL ON1
            //          0x0D04,     ->      FAN MIDDLE LEVEL ON1
            //          0x0D68,     ->      FAN HIGH LEVEL ON1
            //          0x0DFE,     ->      FAN MAXIMUM LEVEL ON1
            //          0x0E94, 
            //          0x0FA3

            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24D");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 70;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24D");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24D");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C239", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C24D");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region Class for HP NC6220 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN Control (default value)
            // - - - - - - - - - - - - - - -
            //
            // Name (C239, Package (0x05)
            // {
            //    0x64,             // 100°C    <- FAN maximum level
            //    0x41,             // 65°C     <- FAN high level
            //    0x37,             // 55°C     <- FAN middle level
            //    0x28,             // 40°C     <- FAN low level
            //    0x00
            // })


            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 40;                                // It must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                         // minimum input value
                    public const int nhc_maximum_value = 100;                        // maximum input value
                    public const int nhc_default_value = 40;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23A", "PKG[3]", fan_low_speed) == true)   // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_middle_speed = 55;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 55;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23A", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_high_speed = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 65;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23A", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            //
            public static class FAN_MAXIMUM_SPEED
            {
                // Properties of the value class
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;

                // Value
                public static int fan_maximum_speed = 65;
                public const string unit = " %";

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C23A", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C250._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C250._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C250._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C251._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C251._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C251._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C252._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C252._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C252._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C253._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C253._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C253._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }  //
    #endregion
    // works perfect F.12

    #region Notebook HP NC2400 : class NC2400

    public static class NC2400
    {
        #region Class for Hardware control : class HARDWARE
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_thermal_range1 = 50;		                    // upper threshold limit - it must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public const int base_level = 2732;			                    // bias for �K to °C conversion
                    public const int range = 5;                                     // hysteresis in °C
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2B2", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2B2", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            public static class FAN_THERMAL_RANGE2
            {
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range2 = 60;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2B2", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2B2", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            public static class FAN_THERMAL_RANGE3
            {
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range3 = 72;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 72;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2B2", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2B2", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            public static class FAN_THERMAL_RANGE4
            {
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;
                public static int fan_thermal_range4 = 83;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 83;
                    public const int base_level = 2732;
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {
                        ACPI.PACKAGE.Write("_TZ.C2B2", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level);
                        ACPI.PACKAGE.Write("_TZ.C2B2", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level);
                        return refresh_thermal_zone();
                    }
                }
            }
            #endregion

            #region refresh_thermal_zone()                                                      // internal sub refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                int temp1 = 0;
                int temp2 = 0;
                int processor_range4 = 0;
                int processor_range3 = 0;
                int processor_range2 = 0;
                int processor_range1 = 0;
                bool result = false;

                ACPI.METHOD.GetValue("_TZ.TZ0._TMP", ref temp1);                                // read actual processor temperature
                ACPI.METHOD.GetValue("_TZ.TZ2._TMP", ref temp2);                                // read actual graphics temperature 

                ACPI.PACKAGE.Read("_TZ.C2B2", "PKG[0].PKG[1].PKG[3]", ref processor_range4);    // read actual processor range (Fan maximum speed)
                ACPI.PACKAGE.Read("_TZ.C2B2", "PKG[0].PKG[1].PKG[2]", ref processor_range3);    // read actual processor range (Fan high speed)
                ACPI.PACKAGE.Read("_TZ.C2B2", "PKG[0].PKG[1].PKG[1]", ref processor_range2);    // read actual processor range (Fan medium speed)
                ACPI.PACKAGE.Read("_TZ.C2B2", "PKG[0].PKG[1].PKG[0]", ref processor_range1);    // read actual processor range (Fan low speed) 

                // This switch off the Fan
                ACPI.METHOD.Call("_TZ.C2C9._OFF");
                ACPI.METHOD.Call("_TZ.C2CA._OFF");
                ACPI.METHOD.Call("_TZ.C2CB._OFF");
                ACPI.METHOD.Call("_TZ.C2CC._OFF");

                if (temp1 > processor_range4)
                {
                    result = ACPI.METHOD.Call("_TZ.C2C9._ON");
                    result = ACPI.METHOD.Call("_TZ.C2CA._ON");
                    result = ACPI.METHOD.Call("_TZ.C2CB._ON");
                    result = ACPI.METHOD.Call("_TZ.C2CC._ON");
                }
                else
                {
                    if (temp1 > processor_range3)
                    {
                        result = ACPI.METHOD.Call("_TZ.C2C9._OFF");
                        result = ACPI.METHOD.Call("_TZ.C2CA._ON");
                        result = ACPI.METHOD.Call("_TZ.C2CB._ON");
                        result = ACPI.METHOD.Call("_TZ.C2CC._ON");
                    }
                    else
                    {
                        if (temp1 > processor_range2)
                        {
                            result = ACPI.METHOD.Call("_TZ.C2C9._OFF");
                            result = ACPI.METHOD.Call("_TZ.C2CA._OFF");
                            result = ACPI.METHOD.Call("_TZ.C2CB._ON");
                            result = ACPI.METHOD.Call("_TZ.C2CC._ON");
                        }
                        else
                        {
                            if (temp1 > processor_range1)
                            {
                                result = ACPI.METHOD.Call("_TZ.C2C9._OFF");
                                result = ACPI.METHOD.Call("_TZ.C2CA._OFF");
                                result = ACPI.METHOD.Call("_TZ.C2CB._OFF");
                                result = ACPI.METHOD.Call("_TZ.C2CC._ON");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C2C9._OFF");
                                result = ACPI.METHOD.Call("_TZ.C2CA._OFF");
                                result = ACPI.METHOD.Call("_TZ.C2CB._OFF");
                                result = ACPI.METHOD.Call("_TZ.C2CC._OFF");
                            }
                        }
                    }
                }
                return result;
            }
            #endregion
        }
        #endregion

        #region Class for HP NC2400 FAN-SPEED control : class FAN
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN-SPEED Control";         // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 55;                               // it must have the same name as the class (case are ignored)
                public const string unit = " %";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                        // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 55;                        // default value, 55 = 0x37
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2B3", "PKG[3]", fan_low_speed) == true)   // set the low_speed_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone temperature interval
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            public static class FAN_MIDDLE_SPEED
            {
                public const string description = "FAN middle speed";
                public const bool nhc_visible = true;
                public static int fan_middle_speed = 70;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2B3", "PKG[2]", fan_middle_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            public static class FAN_HIGH_SPEED
            {
                public const string description = "FAN high speed";
                public const bool nhc_visible = true;
                public static int fan_high_speed = 80;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2B3", "PKG[1]", fan_high_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            public static class FAN_MAXIMUM_SPEED
            {
                public const string description = "FAN maximum speed";
                public const bool nhc_visible = true;
                public static int fan_maximum_speed = 100;
                public const string unit = " %";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 15;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;
                    public static bool nhc_on_write()
                    {
                        if (ACPI.PACKAGE.Write("_TZ.C2B3", "PKG[0]", fan_maximum_speed) == true)
                        {
                            return refresh_thermal_zone();
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            #endregion

            #region __refresh_thermal_zone()
            //
            // internal sub refresh function for the ThermalZone
            //
            private static bool __refresh_thermal_zone()
            {
                int status = 0;
                bool result = false;
                if (ACPI.METHOD.GetValue("_TZ.C2C9._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.C2C9._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.C2C9._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.C2CA._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.C2CA._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.C2CA._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                    else
                    {
                        if (ACPI.METHOD.GetValue("_TZ.C2CB._STA", ref status) == false)
                        {
                            return false;
                        }
                        if (status == 0)
                        {
                            result = ACPI.METHOD.Call("_TZ.C2CB._OFF");
                        }
                        else
                        {
                            result = ACPI.METHOD.Call("_TZ.C2CB._ON");
                        }
                        if (result == false)
                        {
                            return false;
                        }
                        else
                        {
                            if (ACPI.METHOD.GetValue("_TZ.C2CC._STA", ref status) == false)
                            {
                                return false;
                            }
                            if (status == 0)
                            {
                                result = ACPI.METHOD.Call("_TZ.C2CC._OFF");
                            }
                            else
                            {
                                result = ACPI.METHOD.Call("_TZ.C2CC._ON");
                            }
                        }
                    }
                }
                return result;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }

        #endregion
    }

    #endregion
    // test BIOS: F.0A

    #region Notebook HP NC4010 : class NC4010
    //
    // class author: Henry100
    //
    public static class NC4010
    {
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1DC");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1DC");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1DC");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1DD", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1DC");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

    }
    #endregion
    // no fan-speed F.2F
}